﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

//We implement ICloneable so we can clone from GameController and manage locally in individual game phases
public interface ICloneable<T>
{
    T Clone();
}


public abstract class TimerInterval : ICloneable<TimerInterval>
{
    public int IntervalValue { get; protected set; }    //The value to tick at

    public TimerInterval(int intervalValue)
    {
        IntervalValue = intervalValue;
    }

    public virtual void PlayTick()
    {
        AudioManager.Instance.PlaySFX(AudioManager.Instance.TimerTickAudio);
    }

    public virtual TimerInterval Clone()
    {
        return null;
    }
}
